import h5py
import os
from typing import Tuple

import gym
import numpy as np
import tqdm
from absl import app, flags
from ml_collections import config_flags
from tensorboardX import SummaryWriter
import d4rl
import wrappers
from dataset_utils import (Batch, D4RLDataset, ReplayBuffer,
                           split_into_trajectories)
from evaluation import evaluate
from learner import Learner


env = gym.make('antmaze-medium-play-v2')
data = d4rl.qlearning_dataset(env)
f1=h5py.File('../scik/datasets/antmaze-medium-play-v2.hdf5',"w")
for key in data.keys():
    f1[key] = np.array(data[key][:])
    print(key)
    print(len(f1[key]))
f1.close()

